/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.funnel;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.funnel.AbstractDirectionalFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public abstract class FunnelBlock
extends AbstractDirectionalFunnelBlock {
    public static final class_2746 EXTRACTING = class_2746.method_11825((String)"extracting");

    public FunnelBlock(class_4970.class_2251 p_i48415_1_) {
        super(p_i48415_1_);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)EXTRACTING, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean method_72600(class_2680 blockState) {
        return AllBlockEntityTypes.FUNNEL.method_20526(blockState);
    }

    public abstract class_2680 getEquivalentBeltFunnel(class_1922 var1, class_2338 var2, class_2680 var3);

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        boolean sneak = context.method_8036() != null && context.method_8036().method_5715();
        state = (class_2680)state.method_11657((class_2769)EXTRACTING, (Comparable)Boolean.valueOf(!sneak));
        for (class_2350 direction : context.method_7718()) {
            class_2680 blockstate = (class_2680)state.method_11657((class_2769)FACING, (Comparable)direction.method_10153());
            if (!blockstate.method_26184((class_4538)context.method_8045(), context.method_8037())) continue;
            return (class_2680)blockstate.method_11657((class_2769)POWERED, (Comparable)((Boolean)state.method_11654((class_2769)POWERED)));
        }
        return state;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)builder.method_11667(new class_2769[]{EXTRACTING}));
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        boolean shouldntInsertItem;
        boolean bl = shouldntInsertItem = stack.method_31574((class_1792)AllItems.MECHANICAL_ARM) || !this.canInsertIntoFunnel(state);
        if (stack.method_31574((class_1792)AllItems.WRENCH)) {
            return class_1269.field_52423;
        }
        if (hitResult.method_17780() == FunnelBlock.getFunnelFacing(state) && !shouldntInsertItem) {
            if (!level.method_8608()) {
                this.withBlockEntityDo((class_1922)level, pos, be -> {
                    class_1799 toInsert = stack.method_7972();
                    class_1799 remainder = FunnelBlock.tryInsert(level, pos, toInsert, false);
                    if (!class_1799.method_7973((class_1799)remainder, (class_1799)toInsert) || remainder.method_7947() != stack.method_7947()) {
                        player.method_6122(hand, remainder);
                    }
                });
            }
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        if (!world.method_8608()) {
            world.method_8501(context.method_8037(), (class_2680)state.method_28493((class_2769)EXTRACTING));
        }
        return class_1269.field_5812;
    }

    public void method_9548(class_2680 state, class_1937 worldIn, class_2338 pos, class_1297 entityIn, class_10774 handler, boolean bl) {
        if (worldIn.method_8608()) {
            return;
        }
        class_1799 stack = ItemHelper.fromItemEntity(entityIn);
        if (stack.method_7960()) {
            return;
        }
        if (!this.canInsertIntoFunnel(state)) {
            return;
        }
        class_2350 direction = FunnelBlock.getFunnelFacing(state);
        class_243 openPos = VecHelper.getCenterOf((class_2382)pos).method_1019(class_243.method_24954((class_2382)direction.method_62675()).method_1021(entityIn instanceof class_1542 ? -0.25 : -0.125));
        class_243 diff = entityIn.method_73189().method_1020(openPos);
        double projectedDiff = direction.method_10166().method_10172(diff.field_1352, diff.field_1351, diff.field_1350);
        if (projectedDiff < 0.0 == (direction.method_10171() == class_2350.class_2352.field_11056)) {
            return;
        }
        float yOffset = direction == class_2350.field_11036 ? 0.25f : -0.5f;
        ServerFilteringBehaviour filter = BlockEntityBehaviour.get((class_1922)worldIn, pos, ServerFilteringBehaviour.TYPE);
        if (filter.test(stack) && !PackageEntity.centerPackage(entityIn, openPos.method_1031(0.0, (double)yOffset, 0.0))) {
            return;
        }
        class_1799 remainder = FunnelBlock.tryInsert(worldIn, pos, stack, false);
        if (remainder.method_7960()) {
            entityIn.method_31472();
        }
        if (remainder.method_7947() < stack.method_7947() && entityIn instanceof class_1542) {
            ((class_1542)entityIn).method_6979(remainder);
        }
    }

    protected boolean canInsertIntoFunnel(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)POWERED) == false && (Boolean)state.method_11654((class_2769)EXTRACTING) == false;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        return facing == class_2350.field_11033 ? AllShapes.FUNNEL_CEILING : (facing == class_2350.field_11036 ? AllShapes.FUNNEL_FLOOR : AllShapes.FUNNEL_WALL.get(facing));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (context instanceof class_3727 && ((class_3727)context).method_32480() instanceof class_1542 && this.getFacing(state).method_10166().method_10179()) {
            return AllShapes.FUNNEL_COLLISION.get(this.getFacing(state));
        }
        return this.method_9530(state, world, pos, context);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 p_196271_6_, class_2680 p_196271_3_, class_5819 random) {
        this.updateWater(world, tickView, state, pos);
        if (this.getFacing(state).method_10166().method_10178() || direction != class_2350.field_11033) {
            return state;
        }
        class_2680 equivalentFunnel = ProperWaterloggedBlock.withWater(world, this.getEquivalentBeltFunnel(null, null, state), pos);
        if (BeltFunnelBlock.isOnValidBelt(equivalentFunnel, world, pos)) {
            return (class_2680)equivalentFunnel.method_11657(BeltFunnelBlock.SHAPE, (Comparable)((Object)BeltFunnelBlock.getShapeForPosition((class_1922)world, pos, this.getFacing(state), (Boolean)state.method_11654((class_2769)EXTRACTING))));
        }
        return state;
    }
}

